(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30880,        635]
NotebookOptionsPosition[     30047,        612]
NotebookOutlinePosition[     30480,        629]
CellTagsIndexPosition[     30437,        626]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Sandor Balog |  Adolphe Merkle Institute | Universit\[EAcute] de \
Fribourg | Switzerland \n\n2022.12.24\n",
  FontSize->10],
 StyleBox["Mathematica",
  FontSize->10,
  FontSlant->"Italic"],
 StyleBox[" Version 13.0\nsandor.balog@unifr.ch \n\nThis Wolfram / \
Mathematica notebook accompanies the article \[OpenCurlyDoubleQuote]The \
Influence of Fluid Menisci on Nanoparticle Dosimetry in Submerged Cells\
\[CloseCurlyDoubleQuote] written by Christina Glaubitz, Laetitia Haeni, Eva \
Su\[SHacek]nik, Barbara Rothen-Rutishauser, Sandor Balog, and Alke Petri-Fink\
\n\nKeywords: In vitro particle dosimetry, Fluid meniscus, Mathematical \
modelling\n\nThe mathematical model is a continuous and deterministic model \
that comprises two second-order nonlinear and linear partial differential \
equations with corresponding boundary and initial conditions. The model \
addresses the impact of fluid the meniscus in cylindrical wells, and the \
transport equation (advection-diffusion) in three plus one dimensions: \
spatial coordinates and time. The advection-diffusion model is evaluated via \
finite element method, addressing non-interacting colloidally stable \
particles in a quiescent fluid.",
  FontSize->10]
}], "Title",
 Editable->False,
 CellChangeTimes->{{3.566984688178922*^9, 3.566984737163008*^9}, {
   3.566984821465556*^9, 3.5669848219179573`*^9}, {3.5669861535378966`*^9, 
   3.5669861628511133`*^9}, {3.57079252871795*^9, 3.5707925290277886`*^9}, {
   3.5711193320370693`*^9, 3.5711193332271166`*^9}, {3.573047011938319*^9, 
   3.573047012718321*^9}, {3.5730588734616423`*^9, 3.5730589112449083`*^9}, 
   3.573196954132554*^9, {3.573197218843606*^9, 3.573197262323872*^9}, {
   3.5731979107223263`*^9, 3.5731979174306707`*^9}, {3.5817850896271*^9, 
   3.5817850919983044`*^9}, {3.582427660602809*^9, 3.5824276698431787`*^9}, {
   3.589996766323708*^9, 3.5899967688041124`*^9}, {3.5900375598503504`*^9, 
   3.590037560240351*^9}, {3.5900499819684625`*^9, 3.5900499847296677`*^9}, {
   3.590915326222548*^9, 3.5909153264253483`*^9}, 3.5910114176792173`*^9, {
   3.5910752495320854`*^9, 3.59107526363451*^9}, {3.5910753619989967`*^9, 
   3.5910753871937294`*^9}, 3.5910777636367216`*^9, 3.59119873247546*^9, {
   3.5915251003240795`*^9, 3.5915251004644794`*^9}, {3.599997780311984*^9, 
   3.5999977899116964`*^9}, {3.617359885900009*^9, 3.6173598877876215`*^9}, {
   3.619933483293124*^9, 3.619933484899935*^9}, {3.6206345053639855`*^9, 
   3.6206345055199857`*^9}, {3.625547241001376*^9, 3.6255472433856144`*^9}, {
   3.625978803203124*^9, 3.6259788035463157`*^9}, {3.627643118127137*^9, 
   3.6276431201421776`*^9}, {3.641788915072398*^9, 3.6417889189597874`*^9}, {
   3.6481929679700403`*^9, 3.6481929766151686`*^9}, {3.6610646606149883`*^9, 
   3.661064667606288*^9}, {3.676880318068573*^9, 3.676880322509017*^9}, {
   3.680944166995165*^9, 3.6809441696627827`*^9}, {3.6832882728250437`*^9, 
   3.683288274895851*^9}, {3.7066003259094515`*^9, 3.70660032631717*^9}, {
   3.765604871397221*^9, 3.765604873638276*^9}, {3.880853596061011*^9, 
   3.8808536729129124`*^9}, {3.880853758925926*^9, 3.880853837251753*^9}, {
   3.8808538880553985`*^9, 3.88085391644296*^9}, {3.880854177098057*^9, 
   3.880854178051403*^9}, {3.880854231424673*^9, 3.880854231804138*^9}, {
   3.8808544173176517`*^9, 3.880854434239661*^9}, {3.8808650667876987`*^9, 
   3.8808650671970406`*^9}, {3.880865112064717*^9, 3.8808651630888324`*^9}, {
   3.880870093532742*^9, 3.8808701191134834`*^9}, {3.8808733209575725`*^9, 
   3.880873321244728*^9}, {3.8808737982267494`*^9, 3.880873826553402*^9}, {
   3.880874213497046*^9, 3.8808742172791843`*^9}, {3.8808744164074106`*^9, 
   3.8808744262296724`*^9}},
 FontSize->10,
 FontTracking->"Plain",
 FontColor->GrayLevel[1],
 Background->GrayLevel[
  0],ExpressionUUID->"07180e3c-2aee-4b15-b4f1-c3939def6ee6"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.880873302638521*^9, 3.880873304311227*^9}},
 FontSize->10,
 FontWeight->"Plain",
 CellLabel->"In[67]:=",ExpressionUUID->"945868be-4cc8-4d94-b472-5211c1691d90"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<`*\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FrontEndExecute", "[", 
   RowBox[{"FrontEndToken", "[", "\"\<DeleteGeneratedCells\>\"", "]"}], "]"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"<<", "NDSolve`FEM`"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"m", ",", "g"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nano", " ", "=", 
    SuperscriptBox["10", 
     RowBox[{"-", "9"}]]}], ";", 
   RowBox[{"micro", " ", "=", 
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]]}], ";", 
   RowBox[{"milli", "=", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}], ";", 
   RowBox[{"centi", " ", "=", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "2"}]]}], ";", 
   RowBox[{"deci", "=", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "1"}]]}], " ", ";", 
   RowBox[{"kilo", " ", "=", 
    SuperscriptBox["10", "3"]}], " ", ";", 
   RowBox[{"liter", " ", "=", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"deci", " ", "m"}], ")"}], "3"]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"th", "=", 
   RowBox[{"Thickness", "[", 
    RowBox[{"3", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fs", "=", 
   RowBox[{"{", 
    RowBox[{"th", ",", 
     RowBox[{"GrayLevel", "[", "0.", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", "=", 
   RowBox[{"72", "/", "2.54"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sx", "=", " ", 
   RowBox[{"10", " ", "cm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sy", "=", " ", 
   RowBox[{"10", " ", "cm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ls", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontWeight", "\[Rule]", "\"\<Light\>\""}], ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Arial Narrow\>\""}], ",", 
      RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Modelling session is initialized.\>\"", ",", 
     RowBox[{"FontColor", "\[Rule]", "Red"}], ",", 
     RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
     RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellChangeTimes->{{3.798280551390936*^9, 3.798280552796818*^9}, {
   3.8808544769300804`*^9, 3.8808544772824335`*^9}, {3.880854632009389*^9, 
   3.8808546590199575`*^9}, 3.880855399142758*^9, {3.8808554373839703`*^9, 
   3.8808554378014617`*^9}, {3.8808554724015317`*^9, 3.880855473189373*^9}, {
   3.880855776370062*^9, 3.88085577802007*^9}, {3.8808558645180855`*^9, 
   3.8808558699711647`*^9}, {3.8808575205324125`*^9, 3.880857521321461*^9}, {
   3.8808578236004395`*^9, 3.8808578375709424`*^9}, {3.8808582736675386`*^9, 
   3.8808582762853346`*^9}, {3.880865286277163*^9, 3.880865317498328*^9}, {
   3.8808663423632355`*^9, 3.8808664139488544`*^9}, {3.880869471123947*^9, 
   3.8808694721564913`*^9}, {3.880869829499433*^9, 3.8808698301992292`*^9}, 
   3.880869922705253*^9, {3.880871882773572*^9, 3.8808718889331446`*^9}, {
   3.880881400185796*^9, 3.8808814029280825`*^9}, {3.8819827948322945`*^9, 
   3.881982795040038*^9}},
 FontSize->10,
 FontWeight->"Plain",
 Background->GrayLevel[
  0.85],ExpressionUUID->"3a2ca84c-df93-4c79-9ae2-21d9dcebfbeb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input parameters", "Title",
 Editable->False,
 CellChangeTimes->{{3.566984688178922*^9, 3.566984737163008*^9}, {
   3.566984821465556*^9, 3.5669848219179573`*^9}, {3.5669861535378966`*^9, 
   3.5669861628511133`*^9}, {3.57079252871795*^9, 3.5707925290277886`*^9}, {
   3.5711193320370693`*^9, 3.5711193332271166`*^9}, {3.573047011938319*^9, 
   3.573047012718321*^9}, {3.5730588734616423`*^9, 3.5730589112449083`*^9}, 
   3.573196954132554*^9, {3.573197218843606*^9, 3.573197262323872*^9}, {
   3.5731979107223263`*^9, 3.5731979174306707`*^9}, {3.5817850896271*^9, 
   3.5817850919983044`*^9}, {3.582427660602809*^9, 3.5824276698431787`*^9}, {
   3.589996766323708*^9, 3.5899967688041124`*^9}, {3.5900375598503504`*^9, 
   3.590037560240351*^9}, {3.5900499819684625`*^9, 3.5900499847296677`*^9}, {
   3.590915326222548*^9, 3.5909153264253483`*^9}, 3.5910114176792173`*^9, {
   3.5910752495320854`*^9, 3.59107526363451*^9}, {3.5910753619989967`*^9, 
   3.5910753871937294`*^9}, 3.5910777636367216`*^9, 3.59119873247546*^9, {
   3.5915251003240795`*^9, 3.5915251004644794`*^9}, {3.599997780311984*^9, 
   3.5999977899116964`*^9}, {3.617359885900009*^9, 3.6173598877876215`*^9}, {
   3.619933483293124*^9, 3.619933484899935*^9}, {3.6206345053639855`*^9, 
   3.6206345055199857`*^9}, {3.625547241001376*^9, 3.6255472433856144`*^9}, {
   3.625978803203124*^9, 3.6259788035463157`*^9}, {3.627643118127137*^9, 
   3.6276431201421776`*^9}, {3.641788915072398*^9, 3.6417889189597874`*^9}, {
   3.6481929679700403`*^9, 3.6481929766151686`*^9}, {3.6610646606149883`*^9, 
   3.661064667606288*^9}, {3.676880318068573*^9, 3.676880322509017*^9}, {
   3.680944166995165*^9, 3.6809441696627827`*^9}, {3.6832882728250437`*^9, 
   3.683288274895851*^9}, {3.7066003259094515`*^9, 3.70660032631717*^9}, {
   3.765604871397221*^9, 3.765604873638276*^9}, {3.880853596061011*^9, 
   3.8808536729129124`*^9}, {3.880853758925926*^9, 3.880853837251753*^9}, {
   3.8808538880553985`*^9, 3.88085391644296*^9}, {3.880854177098057*^9, 
   3.880854178051403*^9}, {3.880854231424673*^9, 3.880854231804138*^9}, {
   3.8808544173176517`*^9, 3.880854434239661*^9}, {3.880854503131821*^9, 
   3.8808545159461565`*^9}, {3.880855517632905*^9, 3.880855547695004*^9}, {
   3.8808737574873466`*^9, 3.8808737587368455`*^9}, {3.88096883691251*^9, 
   3.880968837259074*^9}, {3.8819827837632017`*^9, 3.8819827847672887`*^9}},
 FontSize->10,
 FontTracking->"Plain",
 FontColor->GrayLevel[1],
 Background->GrayLevel[
  0],ExpressionUUID->"d13d3379-e722-4fd0-aaa6-976069ae0a61"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
   "dirS", "=", 
    "\"\<C:\\\\Users\\\\BalogS\\\\Documents\\\\P\\\\3D model\>\""}], " ", 
   ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Folder", " ", "path", " ", "to", " ", "save", " ", "the", " ", 
    RowBox[{"results", ".", " ", "Please"}], " ", "use", " ", "\\\\", " ", 
    "and", " ", "not", " ", "\\."}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rh", "=", "25"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Volume", "-", 
    RowBox[{"weighted", " ", "mean", " ", "hydrodynamic", " ", "radius", " ", 
     RowBox[{"(", "nm", ")"}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]", "=", 
    RowBox[{"19", " ", 
     SuperscriptBox["10", "3"]}]}], ";", " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Particle", " ", "mass", " ", "density", " ", 
     RowBox[{"(", 
      RowBox[{"g", "/", 
       SuperscriptBox["m", "3"]}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"c0", "=", "10"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Particle", " ", "concentration", " ", 
    RowBox[{"(", 
     RowBox[{"\[Mu]g", "/", "mL"}], ")"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "=", "17.5"}], ";", 
   RowBox[{"(*", " ", 
    RowBox[{"Well", " ", "radius", " ", 
     RowBox[{"(", "mm", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"vol", "=", "3"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Fluid", " ", "volume", " ", "in", " ", "well", " ", 
    RowBox[{"(", "mL", ")"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"St", "=", " ", 
    RowBox[{"70", " ", "1", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]]}]}], ";", " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Fluid", " ", "surface", " ", "tension", " ", 
     RowBox[{"(", 
      RowBox[{"N", "/", "m"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ro", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", "3"]}]}], ";", " ", 
   RowBox[{"(*", 
    RowBox[{" ", 
     RowBox[{"Fluid", " ", "mass", " ", "density", " ", 
      RowBox[{"(", 
       RowBox[{"g", "/", 
        SuperscriptBox["m", "3"]}], ")"}]}], ")"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gr", "=", "10"}], ";", " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Gravitational", " ", "acceleration", " ", 
     RowBox[{"(", 
      RowBox[{"m", "/", 
       SuperscriptBox["s", "2"]}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"TCelsius", "=", "37"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Fluid", " ", "temperature", " ", 
    RowBox[{"(", "\[Degree]C", ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v", "=", "9"}], ";", " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Number", " ", "of", " ", "annuli"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"\[Kappa]", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "7"}]]}]}], ";"}], " ", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Neumann", " ", "boundary", " ", "value", " ", "modelling", " ", "bottom", 
    " ", "affinity", " ", "for", " ", "particle", " ", "association", " ", 
    RowBox[{
     RowBox[{"(", "adsorption", ")"}], " ", "/", " ", "internalization"}], 
    " ", 
    RowBox[{
     RowBox[{"(", "absorption", ")"}], "."}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"The", " ", "smaller", " ", "\[Kappa]"}], ",", " ", 
    RowBox[{"the", " ", "smaller", " ", "the", " ", "affinity", " ", 
     RowBox[{"(", 
      RowBox[{"1", "/", "m"}], ")"}]}], ",", " ", 
    RowBox[{
    "and", " ", "as", " ", "\[Kappa]", " ", "increases", " ", "the", " ", 
     "rate", " ", "of", " ", "uptake", " ", "approaches", " ", "that", " ", 
     "of", " ", "a", " ", "perfectly", " ", "and", " ", "instantaneously", 
     " ", "absorbing", " ", "surface", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Dirichlet", " ", "boundary"}], ")"}], "."}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tep", "=", " ", "24"}], ";", "   ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Time", " ", "end"}], "-", 
     RowBox[{"point", " ", 
      RowBox[{"(", "h", ")"}]}]}], "*)"}], "\[IndentingNewLine]", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"BC", "=", "2"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Boundary", " ", "conditions", " ", "to", " ", "solve", " ", "the", " ", 
      "axis"}], "-", 
     RowBox[{"symmetric", " ", "Young"}], "-", 
     RowBox[{"Laplace", " ", "equation"}]}], ",", " ", 
    RowBox[{
    "assuming", " ", "that", " ", "the", " ", "curvature", " ", "of", " ", 
     "the", " ", "meniscus", " ", "is", " ", 
     RowBox[{"small", "."}]}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Choose", " ", "either", " ", "model", " ", "1", " ", "or", " ", "2."}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"1", ":", " ", 
     RowBox[{"f", 
      RowBox[{"(", 
       RowBox[{"r", "=", "0"}], ")"}]}]}], "=", 
    RowBox[{"z_", "0", " ", "and", " ", 
     RowBox[{
      FormBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          RowBox[{
           RowBox[{
            SubscriptBox["\[PartialD]", "r"], 
            RowBox[{"f", "(", "r", ")"}]}], "|"}], 
          RowBox[{"r", "=", "0"}]], "=", "0"}],
        "MathMLPresentationTag",
        AutoDelete->True],
       TraditionalForm], "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"2", ":", " ", 
    RowBox[{
     FormBox[
      TagBox[
       RowBox[{
        SubscriptBox[
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", "r"], 
           RowBox[{"f", "(", "r", ")"}]}], "|"}], 
         RowBox[{"r", "=", "0"}]], "=", "0"}],
       "MathMLPresentationTag",
       AutoDelete->True],
      TraditionalForm], " ", "and", " ", 
     RowBox[{
      FormBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          RowBox[{
           RowBox[{
            SubscriptBox["\[PartialD]", "r"], 
            RowBox[{"f", "(", "r", ")"}]}], "|"}], 
          RowBox[{"r", "=", "R"}]], "=", 
         RowBox[{
          StyleBox["C",
           FontFamily->"Times",
           FontWeight->"Plain",
           FontSlant->"Plain"], 
          StyleBox["o",
           FontFamily->"Times",
           FontWeight->"Plain",
           FontSlant->"Plain"], 
          RowBox[{
           StyleBox["t",
            FontFamily->"Times",
            FontWeight->"Plain",
            FontSlant->"Plain"], "[", "\[Theta]", "]"}]}]}],
        "MathMLPresentationTag",
        AutoDelete->True],
       TraditionalForm], "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "The", " ", "second", " ", "option", " ", "is", " ", "suited", " ", 
     "better", " ", "to", " ", "larger", " ", "wells", " ", "and", " ", 
     "larger", " ", "fluid", " ", 
     RowBox[{"volumes", ".", "In"}], " ", "such", " ", "cases", " ", "the", 
     " ", "contact", " ", "angle"}], ",", " ", 
    RowBox[{"and", " ", "thus"}], ",", 
    RowBox[{
     RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", "may", " ", "be", " ", 
     "estimated", " ", "directly", " ", "by", " ", "visual", " ", 
     RowBox[{"inspection", "."}]}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "60"}], ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Contact", " ", 
    RowBox[{"angle", " ", "/", " ", 
     RowBox[{"deg", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"FrontEndExecute", "[", 
   RowBox[{"FrontEndToken", "[", "\"\<DeleteGeneratedCells\>\"", "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NotebookEvaluate", "[", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"dirS", ",", "\"\<3D_model_Comp.nb\>\""}], "}"}], "]"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.816318975232027*^9, {3.8163190208241043`*^9, 3.8163190390980563`*^9}, {
   3.816319091243685*^9, 3.816319092648758*^9}, 3.816319444227359*^9, {
   3.8163329612469006`*^9, 3.816332961699896*^9}, {3.816333688801203*^9, 
   3.8163336898792562`*^9}, 3.8163340089185667`*^9, {3.8163408149746437`*^9, 
   3.8163408167844257`*^9}, {3.8163409155759945`*^9, 3.816340937274977*^9}, {
   3.8163412723881483`*^9, 3.8163412753324933`*^9}, 3.816341409877613*^9, {
   3.81634153034256*^9, 3.816341573256206*^9}, {3.8163419014359045`*^9, 
   3.8163419277272224`*^9}, {3.816342063693818*^9, 3.8163420663606434`*^9}, {
   3.8163421174764357`*^9, 3.8163421216738815`*^9}, {3.8163460978016567`*^9, 
   3.816346101259487*^9}, 3.8163461321678057`*^9, {3.816348476757405*^9, 
   3.8163485183621902`*^9}, {3.816353846401376*^9, 3.8163538467137594`*^9}, {
   3.8163546288758607`*^9, 3.8163546605253696`*^9}, {3.81635582525873*^9, 
   3.8163558402708235`*^9}, {3.816355915878889*^9, 3.816355961415818*^9}, {
   3.8163561665433054`*^9, 3.816356167168209*^9}, {3.8163563599307823`*^9, 
   3.816356376661959*^9}, 3.8163564076077433`*^9, {3.8163570338625245`*^9, 
   3.816357039361224*^9}, {3.816357080289894*^9, 3.8163571221409883`*^9}, {
   3.8163572103241043`*^9, 3.816357213526511*^9}, {3.816357295257888*^9, 
   3.8163573008675175`*^9}, {3.8164199725453744`*^9, 3.81642000855366*^9}, {
   3.816420145789807*^9, 3.816420159817793*^9}, {3.8164203338734894`*^9, 
   3.8164204048268538`*^9}, {3.816421209487547*^9, 3.8164212218606668`*^9}, {
   3.8164352149402504`*^9, 3.816435258282748*^9}, {3.816436212475564*^9, 
   3.8164362405793257`*^9}, {3.816440899554779*^9, 3.816440905662757*^9}, {
   3.816440940077989*^9, 3.816440978522341*^9}, {3.816590004166379*^9, 
   3.816590013156328*^9}, {3.8165918522086816`*^9, 3.8165918543958254`*^9}, {
   3.816591885944574*^9, 3.8165919276471596`*^9}, {3.8165973288001165`*^9, 
   3.816597342031347*^9}, 3.8165973884286027`*^9, 3.816597631841973*^9, 
   3.816597935391968*^9, {3.8172720478548756`*^9, 3.817272049082343*^9}, {
   3.865042114230857*^9, 3.865042115724044*^9}, 3.8807110091880584`*^9, {
   3.8807118206220045`*^9, 3.880711822655805*^9}, {3.880712184035248*^9, 
   3.880712187135438*^9}, {3.880714889416601*^9, 3.8807149716186085`*^9}, {
   3.880715008735157*^9, 3.8807150115716968`*^9}, {3.880715085090435*^9, 
   3.8807151230259275`*^9}, {3.880716031139336*^9, 3.8807161919093733`*^9}, {
   3.8807162366130176`*^9, 3.8807163529735126`*^9}, {3.8807164261534324`*^9, 
   3.8807164289431515`*^9}, {3.880717066554194*^9, 3.880717067641052*^9}, {
   3.8807171457235527`*^9, 3.880717187151127*^9}, {3.8807172334172506`*^9, 
   3.8807173303081775`*^9}, {3.8807173769610047`*^9, 3.880717439402605*^9}, {
   3.880717483730625*^9, 3.880717623478962*^9}, {3.880724596980039*^9, 
   3.8807247613417854`*^9}, {3.880724996149357*^9, 3.88072502978286*^9}, {
   3.8807284099826126`*^9, 3.8807284125899754`*^9}, {3.880765669994827*^9, 
   3.8807656839797583`*^9}, {3.880768278533481*^9, 3.8807682857212076`*^9}, 
   3.8807687134915433`*^9, {3.8807691608550043`*^9, 3.880769163308489*^9}, {
   3.880769687800776*^9, 3.880769697422462*^9}, 3.8807698731031303`*^9, {
   3.8807700173192883`*^9, 3.8807700280345254`*^9}, 3.880770292943022*^9, {
   3.8807742138623705`*^9, 3.8807742177748084`*^9}, {3.880774256363869*^9, 
   3.8807742839705667`*^9}, {3.8807743249090385`*^9, 3.880774325737403*^9}, {
   3.880774926942417*^9, 3.8807749630561876`*^9}, {3.8807750047965617`*^9, 
   3.8807750986516867`*^9}, {3.8807761500914383`*^9, 
   3.8807761608932476`*^9}, {3.8807762645639734`*^9, 
   3.8807762796465287`*^9}, {3.8807763374475603`*^9, 
   3.8807763606245737`*^9}, {3.8807764170079184`*^9, 3.88077642341483*^9}, {
   3.8807764660669737`*^9, 3.880776507345168*^9}, 3.8807813415305347`*^9, {
   3.8807857421771193`*^9, 3.880785750998131*^9}, {3.8807860279021215`*^9, 
   3.8807860291669908`*^9}, 3.88078660582837*^9, 3.880786655936799*^9, {
   3.8807873199554443`*^9, 3.8807873322933493`*^9}, {3.8807879700229034`*^9, 
   3.880787975366558*^9}, {3.880788007775596*^9, 3.88078800814342*^9}, {
   3.8807881927696457`*^9, 3.8807882034504833`*^9}, {3.8807895245703955`*^9, 
   3.8807895280898924`*^9}, {3.8807896538160944`*^9, 3.880789671988967*^9}, {
   3.880791329960593*^9, 3.8807913336192913`*^9}, {3.880791385652666*^9, 
   3.8807913899413395`*^9}, {3.880791521091098*^9, 3.8807915214160423`*^9}, {
   3.8807918511993523`*^9, 3.880791852178254*^9}, {3.880792926320291*^9, 
   3.8807929504541397`*^9}, {3.8808022595887127`*^9, 
   3.8808022698424034`*^9}, {3.8808087096999197`*^9, 3.880808710125379*^9}, {
   3.880853951484706*^9, 3.8808539734361024`*^9}, {3.8808540075061116`*^9, 
   3.8808541192155523`*^9}, 3.8808542357194395`*^9, {3.8808544710705366`*^9, 
   3.8808544832750635`*^9}, {3.8808545526605387`*^9, 3.880854623557928*^9}, {
   3.8808546960018463`*^9, 3.880855144321552*^9}, {3.8808552550929537`*^9, 
   3.880855263568162*^9}, {3.8808553842264338`*^9, 3.8808553846984606`*^9}, {
   3.8808554243263974`*^9, 3.8808554472498984`*^9}, 3.880855594213647*^9, {
   3.8808559117554235`*^9, 3.880855939895918*^9}, {3.880856388523351*^9, 
   3.8808563917874527`*^9}, {3.8808566927415795`*^9, 
   3.8808566930907125`*^9}, {3.880856893859056*^9, 3.8808569048845577`*^9}, {
   3.8808574860375586`*^9, 3.880857486484024*^9}, {3.880857535453083*^9, 
   3.8808575538904247`*^9}, {3.880858417950861*^9, 3.8808584188767185`*^9}, {
   3.880861042134842*^9, 3.8808610633578453`*^9}, {3.8808611252409887`*^9, 
   3.880861168536084*^9}, 3.880861202693206*^9, {3.88086124035274*^9, 
   3.880861268377274*^9}, 3.8808612992144613`*^9, {3.8808613950923758`*^9, 
   3.880861396550558*^9}, {3.8808616405842705`*^9, 3.880861642979974*^9}, {
   3.8808633034946995`*^9, 3.8808633038897915`*^9}, {3.880863664984917*^9, 
   3.88086366557539*^9}, {3.8808637425430727`*^9, 3.8808637661277456`*^9}, {
   3.880863804781946*^9, 3.8808638167958665`*^9}, {3.880864217798566*^9, 
   3.8808642289888496`*^9}, {3.8808642679062185`*^9, 3.880864364823517*^9}, 
   3.8808644244164753`*^9, {3.8808645058959*^9, 3.8808645339131804`*^9}, {
   3.880865513633031*^9, 3.880865515718623*^9}, {3.880866036859145*^9, 
   3.880866099128686*^9}, {3.880866279875702*^9, 3.880866329898492*^9}, {
   3.8808664205347304`*^9, 3.880866442723757*^9}, {3.880866552753517*^9, 
   3.8808665547688665`*^9}, {3.8808667336072254`*^9, 3.880866734651164*^9}, {
   3.8808672466625867`*^9, 3.880867246945246*^9}, {3.880868486482089*^9, 
   3.880868489238491*^9}, 3.8808687051166906`*^9, 3.880868798296546*^9, {
   3.8808688604235487`*^9, 3.8808688647289257`*^9}, 3.88086956842255*^9, 
   3.8808698353069115`*^9, 3.8808699221799645`*^9, {3.8808699896025524`*^9, 
   3.8808699933264933`*^9}, 3.8808701282999077`*^9, {3.8808702955796347`*^9, 
   3.8808702958174877`*^9}, {3.8808710291088896`*^9, 
   3.8808711158723555`*^9}, {3.8808712335819445`*^9, 
   3.8808712350128565`*^9}, {3.8808714731422296`*^9, 3.88087147526013*^9}, {
   3.880873357872287*^9, 3.880873404607953*^9}, {3.8808734663170652`*^9, 
   3.8808734879008904`*^9}, 3.8808735862060933`*^9, {3.8808738868371973`*^9, 
   3.880873912145999*^9}, {3.880881238160097*^9, 3.880881245995053*^9}, 
   3.8808812830408993`*^9, {3.880881364014385*^9, 3.8808813652962713`*^9}, {
   3.880881404548173*^9, 3.880881405752846*^9}, {3.880888843009657*^9, 
   3.880888844467394*^9}, {3.880888967658992*^9, 3.880888967890373*^9}, {
   3.880895271510844*^9, 3.880895278697406*^9}, {3.880968784379923*^9, 
   3.8809688218663445`*^9}, {3.8809689009304833`*^9, 3.8809689088504496`*^9}, 
   3.880969359084058*^9, {3.880970050245888*^9, 3.880970059567897*^9}, 
   3.8809702721466208`*^9, 3.8809720731278934`*^9, {3.8809728982612634`*^9, 
   3.88097289872598*^9}, {3.880987071212161*^9, 3.880987071561124*^9}, {
   3.880993365495177*^9, 3.880993372310665*^9}, 3.880993710137429*^9, {
   3.881030182141914*^9, 3.8810301879234*^9}, 3.8810311539967327`*^9, 
   3.881031484684337*^9, {3.88103400222723*^9, 3.881034002838787*^9}, {
   3.881035105645545*^9, 3.8810351112312217`*^9}, {3.881035395576852*^9, 
   3.8810353956731863`*^9}, 3.881037762504177*^9, {3.8810388861866817`*^9, 
   3.8810388864528284`*^9}, {3.8810508082610044`*^9, 3.88105081345514*^9}, {
   3.881051382201769*^9, 3.881051385214091*^9}, 3.8810516929018784`*^9, {
   3.8810532724983473`*^9, 3.881053275682474*^9}, {3.88105369489054*^9, 
   3.8810536990852213`*^9}, {3.8811193436334486`*^9, 3.881119373771745*^9}, {
   3.881119722413188*^9, 3.88111973702297*^9}, {3.8811201048324895`*^9, 
   3.881120105664744*^9}, {3.8811203064282136`*^9, 3.881120312336568*^9}, {
   3.881120837585478*^9, 3.8811208695368567`*^9}, {3.8811225982955713`*^9, 
   3.8811226047091565`*^9}, 3.881123435003935*^9, {3.8811235185617843`*^9, 
   3.881123522657981*^9}, {3.881126382007419*^9, 3.881126394239603*^9}, {
   3.8811390674240465`*^9, 3.8811390678617153`*^9}, 3.881144583697853*^9, {
   3.881745144209073*^9, 3.881745178213104*^9}, {3.8817609755558233`*^9, 
   3.8817609789128733`*^9}, {3.8818005237566442`*^9, 3.881800524336693*^9}, {
   3.881800564485075*^9, 3.8818005895624714`*^9}, {3.8818006311793003`*^9, 
   3.8818009408294983`*^9}, {3.8818010283501415`*^9, 3.8818010576036267`*^9}, 
   3.88180131856266*^9, {3.88180147016739*^9, 3.881801470801626*^9}, {
   3.881801946182164*^9, 3.881801962864352*^9}, {3.8818020381147833`*^9, 
   3.8818020421604967`*^9}, 3.8818021607825136`*^9, {3.881802221396093*^9, 
   3.881802225638857*^9}, 3.8818071905669823`*^9, 3.881807948610545*^9, {
   3.88180800215863*^9, 3.8818080104361286`*^9}, {3.8818093312250576`*^9, 
   3.8818093497046432`*^9}, 3.881810734573161*^9, {3.8818124171588345`*^9, 
   3.881812425263956*^9}, {3.881813241807585*^9, 3.8818132543110695`*^9}, 
   3.8818133991765585`*^9, {3.8818150234816523`*^9, 3.881815023607025*^9}, {
   3.8818152425286922`*^9, 3.881815256048792*^9}, {3.881815325663768*^9, 
   3.881815341179042*^9}, {3.88181692967334*^9, 3.8818169442868214`*^9}, 
   3.8818227866011715`*^9, {3.881824080155967*^9, 3.881824080501054*^9}, {
   3.8818244783941*^9, 3.8818244935422883`*^9}, {3.881824690191683*^9, 
   3.8818247109028697`*^9}, {3.881826360327924*^9, 3.8818263897759323`*^9}, {
   3.88182870042289*^9, 3.8818287048291907`*^9}, {3.8818289935527906`*^9, 
   3.881828993829393*^9}, {3.8818298191110144`*^9, 3.8818298194861946`*^9}, 
   3.881830501371787*^9, {3.881887671784724*^9, 3.8818877083332357`*^9}, {
   3.881888152044984*^9, 3.8818881526917114`*^9}, {3.881888328148977*^9, 
   3.881888329070673*^9}, {3.881888648063135*^9, 3.8818886640792212`*^9}, {
   3.881888962554138*^9, 3.881888963694779*^9}, {3.881889269684592*^9, 
   3.8818893040915174`*^9}, 3.88188961508409*^9, {3.8818898991470566`*^9, 
   3.881889899292452*^9}, {3.8818902870892286`*^9, 3.8818903000736756`*^9}, {
   3.881982801647871*^9, 3.8819828161864147`*^9}},
 FontSize->10,
 FontWeight->"Plain",
 FontColor->GrayLevel[0],
 Background->GrayLevel[
  0.85],ExpressionUUID->"cfd6caa3-7c47-4f60-ba39-7c44196671b2"]
}, Open  ]]
},
WindowSize->{1428., 743.25},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1. Inherited,
FrontEndVersion->"13.0 for Microsoft Windows (64-bit) (December 2, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e574a71f-9d75-4082-ab2e-db1a87ce7cbe"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3866, 61, 256, "Title",ExpressionUUID->"07180e3c-2aee-4b15-b4f1-c3939def6ee6"],
Cell[4449, 85, 234, 5, 25, "Input",ExpressionUUID->"945868be-4cc8-4d94-b472-5211c1691d90"],
Cell[4686, 92, 3562, 91, 265, "Input",ExpressionUUID->"3a2ca84c-df93-4c79-9ae2-21d9dcebfbeb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8285, 188, 2537, 37, 69, "Title",ExpressionUUID->"d13d3379-e722-4fd0-aaa6-976069ae0a61"],
Cell[10825, 227, 19206, 382, 496, "Input",ExpressionUUID->"cfd6caa3-7c47-4f60-ba39-7c44196671b2"]
}, Open  ]]
}
]
*)

